import pandas as pd
from general_functions import calculate_averages, calculate_square_root

def main():
    # Sample Data: Create a DataFrame with student grades
    data = {
        'Student': ['Alice', 'Bob', 'Charlie', 'David', 'Eva'],
        'Math': [85, 90, 78, 92, 88],
        'Science': [89, 94, 80, 85, 91],
        'English': [75, 85, 82, 88, 79]
    }
    
    # Create a DataFrame
    df = pd.DataFrame(data)
    
    # Use the calculate_averages function from the module
    df_with_averages = calculate_averages(df[['Math', 'Science', 'English']])
    
    # Display the DataFrame with the Average column
    print("DataFrame with Average Grades:")
    print(df_with_averages)
    
    # Example of using the calculate_square_root function
    value = 16
    sqrt_value = calculate_square_root(value)
    print(f"\nThe square root of {value} is {sqrt_value}")

if __name__ == "__main__":
    main()