from setuptools import setup, find_packages

setup(
    name="cs316_package",
    version="0.1.0",
    author="Anis Koubaa",
    author_email="anis.koubaa@gmail.com",
    description="Educational package for CS316 course",
    long_description="This package contains functions and utilities for the CS316 course.",
    long_description_content_type="text/markdown",
    url="https://github.com/aniskoubaa/cs316_package",
    packages=find_packages(),
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    python_requires='>=3.9',
    install_requires=[
        "numpy",       # Numerical computations
        "pandas",       # Data manipulation and analysis
        "matplotlib",   # Plotting and visualization
        "seaborn"      # Statistical data visualization
    ],
    entry_points={
        'console_scripts': [
            'cs316-cli=cs316_package.command_line:main',
        ],
    },
)