#define a list of temperatures
temperatures = [23, 25, 31, 35, 40, 39, 41, 32, 25, 28]

#tuple is an immutable list
tuple_temperatures = (23, 25, 31, 23, 40, 39, 23, 32, 25, 25)
print('tuple temperatures: ', tuple_temperatures)

#set of unique temperatures
set_temperatures = {23, 25, 31, 23, 40, 39, 23, 32, 25, 25}
print('set temperatures: ', set_temperatures)

print('temperatures: ', temperatures)

#calculate the average temperature
total_days = len(temperatures)
total_temperature = sum(temperatures)
average_temperature = total_temperature / total_days

average_temperature = sum(temperatures) / len(temperatures)

#display the average temperature
print('average temperature: ', average_temperature)
print(f"average temperature: {average_temperature:.2f}")

#Step 2: Loops and Conditions
#filter temperatures above 30
hot_days = []
for temp in temperatures:
    if temp > 30:
        hot_days.append(temp)
    elif temp == 30:
        print('it is a hot day')
    else:
        print('it is a cold day')
    
print('hot days: ', hot_days)

#List Comprehension
hot_days_lc = [temp for temp in temperatures if temp > 30]

#calculate the average temperature of hot days
average_temperature_hot_days = sum(hot_days) / len(hot_days)
print('average temperature of hot days: ', average_temperature_hot_days)
print(f"average temperature of hot days: {average_temperature_hot_days:.2f}")

#Built-in Data Structures
#Dictionary is a collection of key-value pairs
#key is unique
#value can be any data type
#dictionary is mutable
#dictionary is unordered

#Create a dictionary of daily temperatures
daily_temperatures = {
    '2023-01-01': 23,
    '2023-01-02': 25,
    '2023-01-03': 23,
    '2023-01-04': 35,
    '2023-01-05': 40,
    '2023-01-06': 39
    }

#access a certain value using the key
print('temperature on 2023-01-01: ', daily_temperatures['2023-01-01'])

#add a new key-value pair
daily_temperatures['2023-01-07'] = 41

#update a value
daily_temperatures['2023-01-03'] = 31

#delete a key-value pair
del daily_temperatures['2023-01-01']

#go over the elements using a for loop
for date, temp in daily_temperatures.items():
    print(f"temperature on {date}: {temp}")

#go over the elements using a for loop through the keys
for date in daily_temperatures:
    print(f"temperature on {date}: {daily_temperatures[date]}")

#filter temperatures above 30
hot_days_dict = {date: temp for date, temp in daily_temperatures.items() if temp > 30}

#list of all temperatures
temperatures = list(daily_temperatures.values())
print('temperatures: ', temperatures)

#avg temperature of hot days
average_temperature_hot_days_dict = sum(hot_days_dict.values()) / len(hot_days_dict)

#get the keys and the values of a dictionary
dates = daily_temperatures.keys()
print(type(dates))
dates_list = list(dates)
print(type(dates_list))
print('dates: ', dates)

#get the unique temperature values
unique_temperatures = set(daily_temperatures.values())

try:
    print(daily_temperatures['2023-01-03'])
    #check if a key exists in a dictionary
    if '2023-01-02' in daily_temperatures:
        print('the key exists')
        print('temperature on 2023-01-02: ', daily_temperatures['2023-01-02'])
        x = 2/0
except KeyError:
    print('[KeyError] The key does not exist')
except Exception as e:
    print(f'General Exception occured. Error: {e}')

#Step 3: Functions
#function is a block of code that performs a specific task

#function to calculate the average temperature
def calculate_average_temperature(temps: list)->float:
    total_days = len(temps)
    total_temperature = sum(temps)
    average_temperature = total_temperature / total_days
    return average_temperature

#function to filter hot days   
def filter_hot_days(temps, threshold):
    hot_days = [temp for temp in temps if temp > threshold]
    return hot_days

#apply the functions
x=int(30)
average_temperature = calculate_average_temperature(temperatures)
print('average temperature: ', average_temperature)


#Phase 3: Lambda Functions
#lambda function is an anonymous function
#lambda function can have multiple arguments but only one expression
#lambda function is used when a function is needed for a short period of time

#lambda function to calculate the average temperature
calculate_average_temperature_lambda = lambda temps: sum(temps) / len(temps)

#calculate the average temperature using the lambda function
average_temperature_lambda = calculate_average_temperature_lambda(temperatures)
print('average temperature using lambda: ', average_temperature_lambda)

#anonymous function to filter hot days
filter_hot_days_lambda = lambda temps, threshold: [temp for temp in temps if temp > threshold]
filter_hot_days_lambda(temperatures, 30)